using System;
using System.Collections.Generic;
using System.Linq;

class Vector
{
    public long x, y;
    public double angle;
    public int index;
}

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var a = new List<Vector>();

        for (int i = 1; i <= n; i++)
        {
            var s = Console.ReadLine().Split();
            long x = long.Parse(s[0]);
            long y = long.Parse(s[1]);

            a.Add(new Vector
            {
                x = x,
                y = y,
                angle = Math.Atan2(y, x),
                index = i
            });
        }

        a.Sort((u, v) => u.angle.CompareTo(v.angle));

        int m = a.Count;
        for (int i = 0; i < m; i++)
        {
            a.Add(new Vector
            {
                x = a[i].x,
                y = a[i].y,
                angle = a[i].angle + 2 * Math.PI,
                index = a[i].index
            });
        }

        long bestX = 0, bestY = 0;
        int bestL = 0, bestR = -1;

        long curX = 0, curY = 0;
        int l = 0;

        for (int r = 0; r < a.Count; r++)
        {
            curX += a[r].x;
            curY += a[r].y;

            while (a[r].angle - a[l].angle > Math.PI)
            {
                curX -= a[l].x;
                curY -= a[l].y;
                l++;
            }

            if (curX * curX + curY * curY > bestX * bestX + bestY * bestY)
            {
                bestX = curX;
                bestY = curY;
                bestL = l;
                bestR = r;
            }
        }

        var result = new List<int>();
        for (int i = bestL; i <= bestR; i++)
            result.Add(a[i].index);

        Console.WriteLine(result.Count);
        if (result.Count > 0)
            Console.WriteLine(string.Join(" ", result));
    }
}